'use client';

import { useLanguage } from "@/contexts/LanguageContext"; // ✅ استدعاء اللغة من الكونتكست

interface PaginationProps {
  currentPage: number;
  totalPages: number;
  onPageChange: (page: number) => void;
}

export default function Pagination({
  currentPage,
  totalPages,
  onPageChange,
}: PaginationProps) {
  const { language } = useLanguage(); // ✅ نجيب اللغة (ar/en)

  if (totalPages <= 1) return null;

  const pages = Array.from(
    { length: Math.min(totalPages, 5) },
    (_, i) => i + 1
  );

  return (
    <div className="flex justify-center items-center gap-2 mt-12">
      {/* Previous */}
      <button
        onClick={() => onPageChange(currentPage - 1)}
        disabled={currentPage === 1}
        className="px-4 py-2 text-gray-600 bg-white border rounded-lg hover:bg-gray-50 disabled:opacity-50 disabled:cursor-not-allowed cursor-pointer"
      >
        {language === "ar" ? "السابق" : "Previous"}
      </button>

      {/* Page numbers */}
      {pages.map((pageNum) => (
        <button
          key={pageNum}
          onClick={() => onPageChange(pageNum)}
          className={`px-4 py-2 border rounded-lg cursor-pointer ${pageNum === currentPage
            ? "bg-primary-600 text-white border-primary-600"
            : "text-gray-600 bg-white hover:bg-gray-50"
            }`}
        >
          {pageNum}
        </button>
      ))}

      {/* Ellipsis + last page */}
      {totalPages > 5 && (
        <>
          <span className="px-2 text-gray-400">...</span>
          <button
            onClick={() => onPageChange(totalPages)}
            className="px-4 py-2 text-gray-600 bg-white border rounded-lg hover:bg-gray-50 cursor-pointer"
          >
            {totalPages}
          </button>
        </>
      )}

      {/* Next */}
      <button
        onClick={() => onPageChange(currentPage + 1)}
        disabled={currentPage === totalPages}
        className="px-4 py-2 text-gray-600 bg-white border rounded-lg hover:bg-gray-50 disabled:opacity-50 disabled:cursor-not-allowed cursor-pointer"
      >
        {language === "ar" ? "التالي" : "Next"}
      </button>
    </div>
  );
}
