import type { NextConfig } from "next";

const wpUrl = new URL(process.env.NEXT_PUBLIC_WORDPRESS_URL || "");

// ✅ Ensure uploads always match the right subdirectory
const uploadsPath = `${wpUrl.pathname.replace(/\/$/, "")}/wp-content/uploads/**`;

const nextConfig: NextConfig = {
  images: {
    remotePatterns: [
      {
        // ✅ TypeScript requires explicit literal for protocol
        protocol: wpUrl.protocol.replace(":", "") as "http" | "https",
        hostname: wpUrl.hostname,
        port: wpUrl.port || undefined, // ✅ must allow undefined
        pathname: uploadsPath, // ✅ this will use the proper uploads path directly
      },
    ],
  },

  // ✅ Add URL rewrites for WordPress menu links
  async rewrites() {
    return [
      // Redirect WordPress category URLs to Next.js category structure
      {
        source: '/category/:slug',
        destination: '/posts/category/:slug',
      },
      {
        source: '/portfolios/:slug',  // WordPress taxonomy URL
        destination: '/portfolio/category/:slug', // Your Next.js structure
      },
    ];
  },
};

export default nextConfig;